// MV3 service worker for debugging declarativeNetRequest rules.
// This logs matched rule IDs to the extension service worker console.

console.log("[AnimeLib Player Fix] service worker loaded", {
  manifestVersion: chrome?.runtime?.getManifest?.()?.manifest_version,
  version: chrome?.runtime?.getManifest?.()?.version,
});

chrome?.runtime?.onInstalled?.addListener?.(() => {
  console.log("[AnimeLib Player Fix] onInstalled");
});

chrome?.runtime?.onStartup?.addListener?.(() => {
  console.log("[AnimeLib Player Fix] onStartup");
});

chrome?.runtime?.onMessage?.addListener?.((msg, sender) => {
  if (msg && msg.type === "ANIME_EXT_PING") {
    console.log("[AnimeLib Player Fix] ping", {
      from: sender?.url,
      tabId: sender?.tab?.id,
    });
  }
});

if (chrome.declarativeNetRequest?.onRuleMatchedDebug?.addListener) {
  chrome.declarativeNetRequest.onRuleMatchedDebug.addListener((info) => {
    // info: {request, rule, ...}
    // Keep logging concise; you can expand if needed.
    // Note: This appears in chrome://extensions -> (this extension) -> Service worker -> Inspect.
    console.log("[AnimeLib Player Fix] DNR matched", {
      ruleId: info?.rule?.ruleId,
      rulesetId: info?.rule?.rulesetId,
      url: info?.request?.url,
      initiator: info?.request?.initiator,
      type: info?.request?.type,
      method: info?.request?.method,
      tabId: info?.request?.tabId,
    });
  });
} else {
  console.log("[AnimeLib Player Fix] onRuleMatchedDebug not available");
}
